# -*- coding: utf-8 -*-
"""
Created on Fri Apr 15 15:34:46 2022

@author: LocalAdmin
"""

from ADwin import ADwin
from time  import sleep
import matplotlib.pyplot as plt

#Boot adwin
device_number = 2
processor_type = '9'
adw = ADwin(device_number, 1)
adw.Boot(adw.ADwindir+'adwin'+processor_type+'.btl')

#Load process
adw.Load_Process('C:/User_data/Damian/Electromigration_UI/Calibration_generator_Damian.T99')

#Set initial values
process_delay = 4000 #4000
adw.Set_Processdelay(9, process_delay)
adw.Set_Par(1, 32768)                           #DAC value
adw.Set_Par(2, 32768)                           #ADC value
        

#Start process
adw.Start_Process(9)

#Get data
cond=0
while cond!=1:
    cond=adw.Get_Par(2) 
    sleep(1)
    #print('Running')
    print(cond)
Data=adw.GetData_Float(1, 1, 65536)  
#Data=[3,2,1,0,1,0]

#Output data(print or write to file)
#adw.Data2File('calTest.txt', 1, 1, 65536, Mode)
with open('C:/User_data/Damian/Electromigration_UI/calTest4.txt', 'w') as f:
    for el in Data:    
        f.write(str((el-32768)/3276.8/4)+'\n')
        
plt.figure()
plt.plot(list(Data))
    
#Stop process
adw.Stop_Process(9)

